#include "connection.h"

/*/////////////////////////////////////////////////////////////////////////////////////////////
Delta Elektronika Zierikzee, the Netherlands 06/06/2010
Created by Tjarco Boerkoel

THIS EXAMPLE IS SUPPLIED "AS IT IS" WITHOUT SUPPORT.

This c file contains example code for communicating with Delta Elektronika PSC-ETH units and Delta Elektronika power supplies with build in PSC-ETH options.
This example program sets the voltage and current values of a PSC-ETH module and reads the data back. 
The connections will be established using the streaming socket TCP protocol to ensure reliability of the data connections. 
In this example the connection will be made by using the socket connect() function. Data will be transfered by using the send() and recv() functions.

Before using this example, be sure the PSC-ETH definitions are set properly.
//////////////////////////////////////////////////////////////////////////////////////////////*/

/*//////  PSC-ETH definitions   ///////*/
#define PSCETH_PORT 8462                         //Fixed TCP port    : 8462
#define PSCETH_IP   "10.1.0.101"                 //Default factory IP: 10.1.0.101         

#define NewVoltage 2.2
#define NewCurrent 5.0
/*/////////////////////////////////////*/

//Prototype functions
int WriteSocket(int SocketFD, char* Buffer, int BufferSize);
int ReadSocket(int SocketFD, char* Buffer, int BufferSize);
int CloseConnection(int SocketFD);
int CreateConnection(void);



int SocketDescriptor;              				//Descriptor pointer for socket
int BytesSend, BytesReceived;      
#define CMDbufferSize 30                              

int main(void)
{   char Vcmd[CMDbufferSize];      				//Voltage command buffer
	char Ccmd[CMDbufferSize];      				//Current command buffer
	int VcmdLength;                				//To store character length of Voltage Command
	int CcmdLength;                				//To store character length of Current Command
  
	float Cset;                    				//Current value to send
	float Vset;                    				//Voltage value to send

    WSADATA wsaData;               				//Struct for WSA
    int Result;                    				//To store result of WSA init       

	//Set the voltage and current setting values
	Cset = NewCurrent;                          //New Current setting to send
	Vset = NewVoltage;                          //New Voltage setting to send

    printf("hit a key to start example\n");      //Text
	getchar();                                   //Wait for a keystroke          
    
    ////////////////Initialise windows sockets///////////////////
    Result = WSAStartup(MAKEWORD(2,2), &wsaData); //This function initiates the use of ws2.dll by a process
    if (Result != NO_ERROR)                      //Check for errors
    {  printf("WSAStartup failed: %d\n", Result); //If error, print report 
      getchar();                                 //Wait for user to confirm
      return 1;                                  //Exit the program
    }

    /////////////Create a connection////////////////////
	SocketDescriptor = CreateConnection();       //Create a connection

	//If socket error, then print error report and exit the program
	if( (SocketDescriptor == SOCKET_ERROR) ||(SocketDescriptor == NULL) )
	{	printf(">ERROR : SocketError, connection failed.. \n ->Socket Error code: %d\n", WSAGetLastError());   //Print error code
	    getchar();	                             //Wait for keystroke
	    WSACleanup();                            //Cleanup winsockets
		return(0);                               //Exit
	}



	//////////Create and send the Delta Elektronika PSC-Ethernet Voltage command./////////////
	VcmdLength = sprintf(Vcmd, "SOURce:VOLTage %f\n", Vset);          	//Create voltage command with new Voltage value
	if(VcmdLength > CMDbufferSize)                                    	//If buffer size to small, print error and exit
	{	printf(">ERROR : Vcmd too long, increment buffer size %d\n", WSAGetLastError());
	    getchar();	
	    WSACleanup();
		return(0);
	}
	printf("Voltage command: %s", Vcmd);                              	//Print command on screen
	BytesSend =  WriteSocket(SocketDescriptor, Vcmd, VcmdLength);            //Send the second PSC-Ethernet command to set the output voltage
	printf("->BytesSend: %d of %d\n\n", BytesSend, VcmdLength);         //Print the result
	
	//////////Create and send the Delta Elektronika PSC-Ethernet Current commands./////////////
	CcmdLength = sprintf(Ccmd, "SOURce:CURRent %f\n", Cset);         	//Create Current command with new Voltage value
	if(CcmdLength > CMDbufferSize) 	                                 	//If buffer size to small, print error and exit.
	{	printf(">ERROR : Ccmd too long, increment buffersize\n");
	    getchar();	
	    WSACleanup();
		return(0);
	}
	printf("Current command: %s", Ccmd);
	BytesSend =  WriteSocket(SocketDescriptor, Ccmd, CcmdLength);    	//Send the first PSC-Ethernet command to set the output current.
	printf("->BytesSend: %d of %d\n\n", BytesSend, CcmdLength);         //Print the result 


    //////////////////////////Wait for user to hit keyboard/////////////////////////
	printf("Hit a key to get the settings\n\n");
	getchar();  




    /////////////Prepaire requests for reading back voltage and current settings//////////////
	//Create the Delta Elektronika PSC-Ethernet get voltage command.
	VcmdLength = sprintf(Vcmd, "SOURce:VOLTage?\n");
	if(VcmdLength > CMDbufferSize)
	{	printf(">ERROR : Vcmd too long, increment buffer size \n");
	    getchar();	
	    WSACleanup();
		return(0);
	}
	BytesSend =  WriteSocket(SocketDescriptor, Vcmd, VcmdLength);                            //Send voltage request
	printf("%s ->BytesSend: %d of %d\n", Vcmd, BytesSend, VcmdLength);                       //Print request info
	
	BytesReceived = ReadSocket(SocketDescriptor, Vcmd, VcmdLength);                          //Read the requested data from the connection and print on screen
	printf(" ->Bytes received: %d\n", BytesReceived);                                        //Print info
	printf(" ->String received: %s\n\n", Vcmd);	                                             //Print info


	
	//Create the Delta Elektronika PSC-Ethernet get current command.
	CcmdLength = sprintf(Ccmd, "SOURce:CURRent?\n");
	if(CcmdLength > CMDbufferSize) 
	{	printf(">ERROR : Ccmd too long, increment buffersize\n");
	    getchar();	
	    WSACleanup();
		return(0);
	}
	BytesSend =  WriteSocket(SocketDescriptor, Ccmd, CcmdLength);                            //Send current request
	printf("%s ->BytesSend: %d of %d\n", Ccmd, BytesSend, CcmdLength);                       //Print request info

	BytesReceived = ReadSocket(SocketDescriptor, Ccmd, CcmdLength);                          //Read the requested information from the connection and print on screen
	printf(" ->Bytes received: %d\n", BytesReceived);                                        //Print info
	printf(" ->String received: %s\n", Ccmd);                                                //Print info
	

	////////Now we're done, close the connection and release dll////////////////
	printf("Done..\n\n");
	CloseConnection(SocketDescriptor);
    WSACleanup();
	printf("Connection closed\n\n");
	printf("exit...");

	//Prevent console from closing by waiting for user key stroke.
	getchar();	

	
	//Exit the program without errors.
//	Exit(0);
	return EXIT_SUCCESS;;
}

	
	
//Create a new connection using TCP streaming socket
int CreateConnection(void)
{	struct sockaddr_in stSockAddr;
    int Result;		//
	int SocketFD;	//Pointer to file Socket FileDescriptor

	//Create socket descriptor for IP4 ip adress. socket datagram packages and udp protocol.
	SocketFD = socket(AF_INET, SOCK_STREAM,IPPROTO_TCP);//	IPPROTO_TCP
	
	//Set the socket connection options (LIKE TYPING A PHONE NUMBER IN YOUR MOBILE PHONE)
     stSockAddr.sin_family = AF_INET;									//Connection type, internetwork: UDP, TCP, etc. 

     stSockAddr.sin_port = htons(PSCETH_PORT);							//Set the port number of the PSC-ETH.
     stSockAddr.sin_addr.s_addr = inet_addr(PSCETH_IP);              	//Convert IP string to usefull format
	
	//If the result is negative or zero it's an error 
	if (stSockAddr.sin_addr.s_addr == INADDR_ANY)                      
	{	close(SocketFD);
		printf(">ERROR : No valid family address\n");
		return -1;	                                                    //Error, no valid address family
	}
	printf(">PASSED: Valid IP family\n");
	
	//If result is zero, it's not a valid IP-address
	if (stSockAddr.sin_addr.s_addr == INADDR_NONE)
	{	close(SocketFD);
		printf(">ERROR : No valid IP-address\n");
		return SOCKET_ERROR;	                                        //Error, no valid ip-address
	}
	printf(">PASSED: Valid IP Address\n");

	//Try to connect the initialised socket descriptor 
	if(SOCKET_ERROR == connect(SocketFD, (const struct sockaddr *)&stSockAddr, sizeof(struct sockaddr_in)) ) 
	{	close(SocketFD);
		printf(">ERROR : Could not open connection.. \n");		          //CONNECTION NOT ACCEPTED OR DESTINATION DOESN'T EXCIST
		return SOCKET_ERROR;
	}
	
	//IF CONNECTION ESTABLISHED, PRINT MESSAGE AND RETURN.
	printf(">PASSED: Connection established!\n\n");
			
	return SocketFD;	//Connection established, return descripter pointer / connection handler
}


//Close the connection with descriptor SocketFD
int CloseConnection(int SocketFD)
{	
	close(SocketFD);
	return 0;
}

//Read from the opened connection. 
//int SocketFD is the  SocketDiscriptor obtained with CreateConnection(void).
//char* Buffer is a poiter to the receive buffer.
//BufferSize is the size of the buffer or the maximum number of bytes to receive.
int ReadSocket(int SocketFD, char* Buffer, int BufferSize)
{   
	int DataReceived = 0;
    int flag;  
    flag = 0;
	
	DataReceived = recv( SocketFD, Buffer, BufferSize, flag);	//in blocking mode, the recv function will keep waiting until data received.

	if(DataReceived == SOCKET_ERROR)
	{	//get error code
	}
	
	if(DataReceived == 0)
	{	printf(">ERROR : Connection lost\n");
	}
	
	return DataReceived;	//Return the number of bytes received (positive number >0 means no error)		
}

//Write to the opened connection.
//int SocketFD is the obtained SocketDiscriptor.
//char* Buffer is a poiter to the receive buffer.
//BufferSize is the size of the buffer or the maximum number of bytes to receive.
int WriteSocket(int SocketFD, char* Buffer, int BufferSize)
{
	int DataSend = 0;
    int flag;
    
    flag = 0;
	if(SocketFD == NULL)	return -1;		                 //Return an error code, socket not valid
	
	DataSend = send( SocketFD, Buffer, BufferSize, flag );	//Send the data
	
	return DataSend;						                //Return the result (number of bytes send, or the error code)
	
}




